﻿using System;
using Microsoft.Xrm.Sdk;

namespace VA.PPMS.IWS.MappingService.Helpers
{
    public static class EnumHelper
    {
        public const int MinYear = 1900;

        public static T MapEnum<T>(string enumText)
        {
            var res = (T)Enum.Parse(typeof(T), enumText);
            return !Enum.IsDefined(typeof(T), res) ? default(T) : res;
        }

        public static OptionSetValue MapEnumToOptionSetValue<T>(string enumText)
        {
            var typeCode = MapEnum<T>(enumText);
            var test = Enum.Parse(typeof(T), typeCode.ToString()) as Enum;
            var x = Convert.ToInt32(test);
            return new OptionSetValue(x);
        }
    }
}